<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('address', 'name', 'phone', 'website', 'logo', 'start_date', 'expected_end_date', 'email');
    protected $visible = array('address', 'name', 'phone', 'website', 'logo', 'start_date', 'expected_end_date', 'email');

    public function company_user_service_stations()
    {
        return $this->hasMany('CompanyUserServiceStation');
    }

}